using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTestingWorklistReport
	/// </summary>
	public class FrmTestingWorklistReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.TestingWorklist _report;
		//
		private System.Windows.Forms.GroupBox grpImage;
        private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.ComponentModel.IContainer components = null;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvTestingWorklist;
		//
		private System.Windows.Forms.PrintDialog printDialog1;
		//

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="testingWorklistReport"></param>
		public FrmTestingWorklistReport(BOL.TestingWorklist testingWorklistReport)
		{
			using ( new WaitCursor())
			{
				InitializeComponent();
				//
				this.SetComponentProperties();
				//
				this._report = testingWorklistReport;
				//
				if (this._report.Patient != null)
				{
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC048.FrmTestingWorklistReport_Patient());
				}
				else
				{
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC048.FrmTestingWorklistReport());
				}
				//
				LoadTestingWorklistReport();
			}
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		/// <param name="specimens"></param>
		public FrmTestingWorklistReport(BOL.Patient patient,
										System.Collections.ArrayList specimens)
		{
			using ( new WaitCursor())
			{
				InitializeComponent();
				//
				this.SetComponentProperties();
				//
				this.hlphelpChm.SetHelpKeyword(this,"Patient_Testing_Worklist_and_Testing_Worklist_Reports.htm");
				//
				this._report = new BOL.TestingWorklist(patient,specimens);
				LoadTestingWorklistReport();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTestingWorklistReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvTestingWorklist = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Testing Worklist Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 28);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(48, 468);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 16);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(40, 40);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 38;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(664, 497);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(584, 497);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvTestingWorklist
            // 
            this.rvTestingWorklist.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvTestingWorklist.Location = new System.Drawing.Point(55, 28);
            this.rvTestingWorklist.Name = "rvTestingWorklist";
            this.rvTestingWorklist.Size = new System.Drawing.Size(684, 468);
            this.rvTestingWorklist.TabIndex = 6;
            this.rvTestingWorklist.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvTestingWorklist_RenderingComplete);
            this.rvTestingWorklist.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvTestingWorklist_RenderingBegin);
            // 
            // FrmTestingWorklistReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(742, 523);
            this.Controls.Add(this.rvTestingWorklist);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Reports_UC_48.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "FrmTestingWorklistReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Testing Worklist Report";
            this.Load += new System.EventHandler(this.FrmTestingWorklistReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvTestingWorklist, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion


		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.ttToolTip.SetToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.ttToolTip.SetToolTip(btnPrint,Common.StrRes.Tooltips.Common.Print().ResString);
            BOL.VbecsReport.SetUpReportButtons(this.rvTestingWorklist);
        }

		private void LoadTestingWorklistReport()
		{
            this._report.GetTestingWorklist();
#if DEBUG
            //Un-comment lines if you need to recreate Xml schema
            //this._report.ReportSectionsTable.WriteXml("e:\\temp\\TestingWorklistDataSet.xml", XmlWriteMode.WriteSchema);
            //this._report.UnitTestingWorklist.WriteXml("e:\\temp\\UnitTestingWorklistDataSet.xml", XmlWriteMode.WriteSchema);
            //this._report.PatientTestingWorklist.WriteXml("e:\\temp\\PatientTestingWorklistDataSet.xml", XmlWriteMode.WriteSchema);
            //this._report.RackTestingWorklist.WriteXml("e:\\temp\\RackTestingWorklistDataSet.xml", XmlWriteMode.WriteSchema);
            //this._report.ReagentTestingWorklist.WriteXml("e:\\temp\\ReagentTestingWorklistDataSet.xml", XmlWriteMode.WriteSchema);
#endif

            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._report.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "TestingWorklistDataSet";
            reportSourceMain.Value = this._report.ReportSectionsTable;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            } 
 
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TestingWorklist.TestingWorklistReport.rdlc");
            Stream streamPatient = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TestingWorklist.PatientTestingWorklist.rdlc");
            Stream streamUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TestingWorklist.UnitTestingWorklist.rdlc");
            Stream streamRack = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TestingWorklist.RackTestingWorklist.rdlc");
            Stream streamReagent = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TestingWorklist.ReagentTestingWorklist.rdlc");

            this.rvTestingWorklist.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvTestingWorklist.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvTestingWorklist.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvTestingWorklist.LocalReport.DataSources.Add(reportSourceMain);
            this.rvTestingWorklist.LocalReport.LoadReportDefinition(stream);
            this.rvTestingWorklist.LocalReport.LoadSubreportDefinition("PatientTestingWorklist", streamPatient);
            this.rvTestingWorklist.LocalReport.LoadSubreportDefinition("UnitTestingWorklist", streamUnit);
            this.rvTestingWorklist.LocalReport.LoadSubreportDefinition("RackTestingWorklist", streamRack);
            this.rvTestingWorklist.LocalReport.LoadSubreportDefinition("ReagentTestingWorklist", streamReagent);

            this.rvTestingWorklist.RefreshReport();
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "PatientTestingWorklist" || e.DataSourceNames[0].ToString() == "PatientTestingWorklistDataSet")
            {
                ReportDataSource reportPatient = new ReportDataSource();
                if (this._report.IncludePatientTesting)
                {
                    reportPatient.Name = "PatientTestingWorklistDataSet";
                    reportPatient.Value = this._report.PatientTestingWorklist;
                }
                e.DataSources.Add(reportPatient);
            }
            else if (e.ReportPath == "UnitTestingWorklist" || e.DataSourceNames[0].ToString() == "UnitTestingWorklistDataSet")
            {
                ReportDataSource reportUnit = new ReportDataSource();
                if (this._report.IncludeUnitTesting)
                {
                    reportUnit.Name = "UnitTestingWorklistDataSet";
                    reportUnit.Value = this._report.UnitTestingWorklist;
                }
                e.DataSources.Add(reportUnit);
            }
            else if (e.ReportPath == "RackTestingWorklist" || e.DataSourceNames[0].ToString() == "RackTestingWorklistDataSet")
            {
                ReportDataSource reportRack = new ReportDataSource();
                if (this._report.IncludeRackTesting)
                {
                    reportRack.Name = "RackTestingWorklistDataSet";
                    reportRack.Value = this._report.RackTestingWorklist;
                }
                e.DataSources.Add(reportRack);
            }
            else if (e.ReportPath == "ReagentTestingWorklist" || e.DataSourceNames[0].ToString() == "ReagentTestingWorklistDataSet")
            {
                ReportDataSource reportReagent = new ReportDataSource();
                if (this._report.IncludeReagentTesting)
                {
                    reportReagent.Name = "ReagentTestingWorklistDataSet";
                    reportReagent.Value = this._report.ReagentTestingWorklist;
                }
                e.DataSources.Add(reportReagent);
            }
        }

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvTestingWorklist.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmTestingWorklistReport_Load(object sender, EventArgs e)
        {

            this.rvTestingWorklist.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTestingWorklist_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvTestingWorklist_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

